﻿
using System;
using System.Collections.Generic;
using System.Text;
using Gemini.Core.BL.Interface.DBD;

namespace PI.ZB.N1200.ELearning.BL.DAL
{
    internal class SchoolYear : PI.FM.N000.Base.BL.DAL.BaseTable<DBD.SchoolYear, BO.SchoolYear>
    {

        internal SchoolYear(Gemini.Core.BL.Interface.IBusinessLogicPlugIn BusinessLogicPlugIn) : this(BusinessLogicPlugIn.Environment, BusinessLogicPlugIn.DriverName) { }

        internal SchoolYear(Gemini.Core.BL.Interface.DAL.IEnvironment Environment, string DriverName) : base(Environment, DriverName, DBD.SchoolYear.DBD) { }

        internal BO.SchoolYear RestoreTopOne(BO.SchoolYear.Search Search)
        {
            return InternalRestoreOne((int)DBD.SchoolYear.Commands.RestoreBySearch,
            delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
            {
                Command["IsActive"].Value = Search.IsActive;
                Command["IsClosed"].Value = Search.IsClosed;
            });
        }

        internal List<BO.SchoolYear> Restore(BO.SchoolYear.Search Search)
        {
            return InternalRestoreList((int)DBD.SchoolYear.Commands.RestoreBySearch,
            delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
            {
                Command["IsActive"].Value = Search.IsActive;
                Command["IsClosed"].Value = Search.IsClosed;
            });
        }

        internal int Count(BO.SchoolYear.Search Search)
        {
            Gemini.Core.BL.Interface.DBD.ICommand _command = InternalExecuteScalar((int)DBD.CompetencePart.Commands.CountBySearch,
                delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
                {
                    Command["IsActive"].Value = Search.IsActive;
                    Command["IsClosed"].Value = Search.IsClosed;
                });

            if (_command != null)
            {
                return Convert.ToInt32(_command["Result"].Value);
            }
            return 0;
        }
    }
}
